﻿using Inet.Viewer.Data;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace Inet.Viewer
{
    /// <summary>
    /// An implementation if this interface receives parsed information of a page during loading the report data.
    /// </summary>
    public interface IPageReceiver
    {
        /// <param name="info"> Sets the report info object, containing various report-wide information such as whether or not
        /// the group tree is to be enabled, the list of possible export formats, the report title, etc. </param>
        /// <param name="loader">the calling loader</param>
        /// <returns> true if rendering should be continued </returns>
        bool WriteReportInfo(ReportInfo info, PageLoader loader);

        /// <param name="info"> Sets the page info object, containing various page-specific information such as page width, page height, etc.
        /// for this page, and causes the page to be renewed to the new settings. </param>
        /// <param name="loader">the calling loader</param>
        /// <returns> true if rendering should be continued  </returns>
        bool WritePageInfo(PageInfo info, PageLoader loader);

        /// <summary>
        /// Retrieves the font specified by its ID and revision - thereby fetching it from the server if necessary </summary>
        /// <param name="fontID"> ID of the font </param>
        /// <param name="fontRevision"> Revision number, that is, number of characters in the font </param>
        /// <returns> Embedded font </returns>
        Font GetEmbeddedFont(int fontID, int fontRevision);

        /// <summary>
        /// Called when the loading of the page fails.
        /// </summary>
        /// <param name="exception">exception with information about the failure</param>
        void PageLoadFailure(Exception exception);
    }
}
